//Listing 12.5. Klasa kontenera z tablic o ustalonym rozmiarze zawierajc komponenty oraz z kontrol przepenienia
#include <iostream>
using namespace std;

class Sample { // klasa komponentu
  double value; // warto prbki
public:
  Sample (double x = 0) // konstruktor domylny oraz konwertujcy
    { value = x; }
  void set (double x) // metoda modyfikatora
    { value = x; }
  double get () const // metoda selektora
    { return value; } } ;

class History { // klasa kontenera: ustaw warto
  enum { size = 8 };
  Sample data[size]; // tablica prbek o ustalonym rozmiarze
  int idx; // indeks biecej prbki
public:
  History() : idx(0) { } // pocztkowo wyczy tablic
  void add(double); // dodaj prbk na kocy
  void print () const; // wywietl histori
  void average () const; // wywietl redni
} ;

void History::add(double s)
{ if (idx < size)
    data[idx++].set(s); } // lub po prostu: data[idx++] = s;

void History::print () const
{ cout << "\n Historia pomiarw:" << endl << endl;
  for (int i = 0; i < size; i++) // indeks lokalny
  cout << " " << data[i].get(); }

void History::average () const
{ cout << "\n Warto rednia: ";
  double sum = 0; // lokalna suma
  for (int i = 0; i < size; i++) // lokalny indeks
    sum += data[i].get();
  cout << sum/size << endl; }

int main()
{ double a[] = {3, 5, 7, 11, 13, 17, 19, 23, 29 } ; // dane wejciowe
  History h; // konstruktor domylny
  for (int i=0; i < 9; i++) // zabezpieczenie przed przepenieniem
  h.add(a[i]); // dodaj histori
  h.print(); // wywietl histori
  h.average(); //wywietl redni
  return 0;
}
